#!/bin/sh


MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK=0
MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR=1
MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=${MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR}
MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""

master_page_sb_image_path_select() {
    debug_print "in function '${FUNCNAME[0]}'"
    
    conf_number_of_sb=`dtascfg "${DTASCFG_XML_FILE}" get sandbox number`
    debug_print "read </configuration/sandbox/number>: ${conf_number_of_sb}"
    
    # check if there is any available sandbox image first
    utility_get_esxi_all_vmx_files \
        "${RT_ESXI_IP:-$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:-$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:-$conf_esxi_password}" \
        "${conf_sb_prefix}" \
        "available"
    if [ -z "${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}" ]; then
        MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE="${MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR}"
        MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
        MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG="${ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SB}"
        return
    fi
    debug_print "vmx files: ${UTILITY_GET_ESXI_ALL_VMX_FILES_MSG}"
    
    tp_esxi_image_select_checklist \
        "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
        "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TEXT}" \
        "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_LABEL_OK}" \
        "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_LABEL_CANCEL}" \
        "${RT_ESXI_IP:=$conf_esxi_ip}" \
        "${RT_ESXI_USERNAME:=$conf_esxi_username}" \
        "${RT_ESXI_PASSWORD:=$conf_esxi_password}" \
        "${conf_sb_prefix}" \
        "available" \
        "${RT_SB_NUMBER:=$conf_number_of_sb}"
    
    debug_print "TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE: ${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE}"
    case "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CODE}" in
    
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_ERROR}" )
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            if [ "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_MSG}" == "${TP_ESXI_IMAGE_SELECT_ERROR_DATASTORE_IS_NOT_FOUND}" ]; then
                MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_DATASTORE
            else
                MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=$ERROR_ESXI_CANNOT_GET_IMAGE_PATH_SB
            fi
            return
            ;;
        
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CANCEL}" )
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=-1
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_CTRLC}" )
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            ;;
            
        "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_OK}" )
            ;;
            
        * )
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ERROR
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG="${MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_UNKNOWN}"
            return
            ;;
    esac

    local selected_images="`echo "${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}" | awk -F ".vmx" '{print NF-1}'`"
    if [ "${selected_images}" -ne 0 ]; then
    
        # user can only select, at most, 3 sandbox image type
        if [ "${selected_images}" -gt 3 ]; then
            debug_print "SelectTooManyImages: count='${selected_images}', img='${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}'"
            
            local text=`printf \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TEXT}" \
                "3"`
            
            tp_msg_ok \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TITLE}" \
                "${text}" \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_LABEL_OK}"
            
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
        fi
        
        # multiple check: 'SandboxTotalNumber' must be multiple of 'SelectedSandboxNumber'
        local is_multiple=`expr $RT_SB_NUMBER % $selected_images`
        if [ "${is_multiple}" -ne 0 ]; then
        
            local text=`printf \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_NOT_MULTIPLES}" \
                "${RT_SB_NUMBER}" \
                "${selected_images}"`
            
            tp_msg_ok \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TITLE}" \
                "${text}" \
                "${STRING_OK}"

            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
        fi
    fi
    
    
    # check if selected images is powered off
    local poweron_img_list
    local msg
    local ret
    local img
    for img in `echo $TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH | sed 's/,/ /g'`
    do
        debug_print "CheckSelectedImagesPowerStatus: img='${img}'"

        msg=`php $CONS_BACKEND get_esxi_vm_state "${RT_ESXI_IP}" "${RT_ESXI_USERNAME}" "${RT_ESXI_PASSWORD}" "${img}"`
        ret="${?}"
        
        if [ "${ret}" -ne 0 ]; then
            local errMsg="CallBackendFunctionsFail: name='get_esxi_vm_state', msg='${msg}'"
            debug_print "${errMsg}"
            
            tp_msg_ok \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TITLE}" \
                "${errMsg}" \
                "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_LABEL_OK}"
                
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
            MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
            return
            
        elif [ "${msg}" = "getstate() = on" ]; then

            # translate to short version
            local tmp
            tmp=`dirname "${img}"`
            tmp=`basename "${tmp}"`
            
            [ -z "${poweron_img_list}" ] \
                && poweron_img_list="${tmp}"  \
                || poweron_img_list="${poweron_img_list}, ${tmp}"
        fi
    done

    if [ ! -z "${poweron_img_list}" ]; then 
        debug_print "CheckSelectedImagesPowerStatusFail: img='${poweron_img_list}'"
            
        tp_msg_ok \
            "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_TITLE}" \
            "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_ERROR_POWEROFF_IMAGE}: ${poweron_img_list}" \
            "${MASTER_PAGE_SB_IMAGE_PATH_SELECT_TOO_MANY_IMAGE_LABEL_OK}"

        MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
        MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=0
        MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
        return
    fi
    debug_print "CheckSelectedImagesPowerStatusPass"
    
    
    # save to runtime variables
    RT_SB_IMAGE_PATH="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_SELECT}"
    RT_SB_IMAGE_PATH_ESXI="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH}"
    RT_SB_IMAGE_PATH_VIX="${TP_ESXI_IMAGE_SELECT_CHECKLIST_RESULT_IMAGE_PATH_VIX}"
    debug_print "RT_SB_IMAGE_PATH: ${RT_SB_IMAGE_PATH}"
    debug_print "RT_SB_IMAGE_PATH_ESXI: ${RT_SB_IMAGE_PATH_ESXI}"
    debug_print "RT_SB_IMAGE_PATH_VIX: ${RT_SB_IMAGE_PATH_VIX}"
    
    MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_CODE=$MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_OK
    MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_ROLLING=1
    MASTER_PAGE_SB_IMAGE_PATH_SELECT_RESULT_MSG=""
}
